import 'package:admin_desktop/app_constants.dart';
import 'package:admin_desktop/application/add_service/add_service_master_provider.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/catalogue/widgets/service_master/widgets/services_modal.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import '../../../../../domain/models/data/service_data.dart';
import 'package:admin_desktop/presentation/components/buttons/custom_button.dart';
import 'package:admin_desktop/presentation/components/keyboard_disable.dart';
import 'package:admin_desktop/presentation/components/text_fields/outline_bordered_text_field.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import '../catalogue/widgets/service/riverpod/service/service_provider.dart';

class UpdateServicePage extends ConsumerStatefulWidget {
  final int id;

  const UpdateServicePage({super.key, required this.id});

  @override
  ConsumerState<UpdateServicePage> createState() => _UpdateServicePage();
}

class _UpdateServicePage extends ConsumerState<UpdateServicePage> {
  final _formKey = GlobalKey<FormState>();
  late TextEditingController commission;
  late TextEditingController discount;
  late TextEditingController pause;
  late TextEditingController price;
  late TextEditingController interval;
  late TextEditingController master;
  late TextEditingController service;
  ServiceData? selectService;

  @override
  void initState() {
    final ServiceData? serviceData =
        ref.read(addServiceMasterProvider).serviceData;
    _setAll(serviceData);
    WidgetsBinding.instance.addPostFrameCallback((d) {});
    super.initState();
  }

  void _setAll(ServiceData? data) {
    commission = TextEditingController(text: "${data?.commissionFee ?? ''}");
    pause = TextEditingController(text: "${data?.pause ?? 0}");
    discount = TextEditingController(text: "${data?.discount ?? 0}");
    price = TextEditingController(text: "${data?.price ?? 0}");
    interval = TextEditingController(text: "${data?.interval ?? ''}");
    master = TextEditingController(text: data?.master?.firstname ?? '');
    service =
        TextEditingController(text: data?.service?.translation?.title ?? "");
    // selectMaster = service?.master;
    selectService = data?.service;
  }

  @override
  void dispose() {
    commission.dispose();
    discount.dispose();
    pause.dispose();
    price.dispose();
    interval.dispose();
    master.dispose();
    service.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return KeyboardDisable(
      child: Container(
        padding: EdgeInsets.all(8),
        width: 590,
        height: 500,
        decoration: BoxDecoration(
            color: Style.white,
            borderRadius: BorderRadius.circular(AppConstants.radius)),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            Row(
              children: [
                BackButton(
                  onPressed: () {
                    Navigator.pop(context);
                    //  ref.read(catalogueProvider.notifier).changeState(2);
                  },
                ),
                20.horizontalSpace,
                Text(
                  AppHelpers.getTranslation(TrKeys.updateService),
                  style: Style.interMedium(size: 20),
                ),
              ],
            ),
            Expanded(
              child: SingleChildScrollView(
                padding: REdgeInsets.symmetric(horizontal: 16),
                physics: const BouncingScrollPhysics(),
                child: Form(
                  key: _formKey,
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      16.verticalSpace,
                      Row(
                        children: [
                          Expanded(

                            child: OutlinedBorderTextField(
                              readOnly: true,
                              label:
                                  '${AppHelpers.getTranslation(TrKeys.service)}*',
                              textInputAction: TextInputAction.next,
                              textController: service,
                              validator: AppValidators.emptyCheck,
                              onTap: () {
                                showDialog(
                                  context: context,
                                  builder: (context) => Dialog(
                                    backgroundColor: Style.transparent,
                                    child: Container(
                                      width: 200,
                                      height: 400,
                                      decoration: BoxDecoration(
                                        color: Style.white,
                                        borderRadius: BorderRadius.circular(AppConstants.radius)
                                      ),
                                      child: ServicesModal(onChange: (value) {
                                        selectService = value;
                                        service.text =
                                            value.translation?.title ?? '';
                                        interval.text =
                                            "${value.interval ?? 0}";
                                        pause.text = "${value.pause ?? 0}";
                                        price.text = "${value.price ?? 0}";
                                      }),
                                    ),
                                  ),
                                );
                              },
                            ),
                          ),
                          30.horizontalSpace,
                          Expanded(

                            child: OutlinedBorderTextField(
                              label:
                                  '${AppHelpers.getTranslation(TrKeys.interval)}*',
                              textInputAction: TextInputAction.next,
                              textController: interval,
                              validator: AppValidators.isNumberValidator,
                              inputFormatters: [InputFormatter.digitsOnly],
                              inputType: TextInputType.number,
                            ),
                          ),
                        ],
                      ),
                      16.verticalSpace,
                      Row(
                        children: [
                          Expanded(

                            child: OutlinedBorderTextField(
                              label:
                                  '${AppHelpers.getTranslation(TrKeys.pause)}*',
                              textInputAction: TextInputAction.next,
                              textController: pause,
                              validator: AppValidators.isNumberValidator,
                              inputFormatters: [InputFormatter.digitsOnly],
                              inputType: TextInputType.number,
                            ),
                          ),
                          30.horizontalSpace,
                          Expanded(

                            child: OutlinedBorderTextField(
                              label:
                                  '${AppHelpers.getTranslation(TrKeys.price)}(\$)*',
                              textInputAction: TextInputAction.next,
                              textController: price,
                              inputType: TextInputType.number,
                              validator: AppValidators.emptyCheck,
                              inputFormatters: [InputFormatter.currency],
                            ),
                          ),
                        ],
                      ),
                      16.verticalSpace,
                      Row(
                        children: [
                          Expanded(

                            child: OutlinedBorderTextField(
                              label:
                                  '${AppHelpers.getTranslation(TrKeys.commissionFee)}(\$)',
                              textInputAction: TextInputAction.next,
                              textController: commission,
                              inputType: TextInputType.number,
                              // validator: AppValidators.emptyCheck,
                              inputFormatters: [InputFormatter.currency],
                            ),
                          ),
                          30.horizontalSpace,
                          Expanded(

                            child: OutlinedBorderTextField(
                              label:
                                  '${AppHelpers.getTranslation(TrKeys.discount)}(\$)',
                              textInputAction: TextInputAction.next,
                              textController: discount,
                              inputType: TextInputType.number,
                              //   validator: AppValidators.emptyCheck,
                              inputFormatters: [InputFormatter.currency],
                            ),
                          ),
                        ],
                      ),
                      16.verticalSpace,

                      60.verticalSpace,
                      CustomButton(
                        textColor: Style.white,
                        width: 250,
                        title: AppHelpers.getTranslation(TrKeys.save),
                        isLoading:
                            ref.watch(addServiceMasterProvider).isUpdating,
                        onTap: () {
                          // if (state.images.isEmpty) {
                          //   AppHelpers.errorSnackBar(context,
                          //       text: TrKeys.imageCantEmpty);
                          //   return;
                          // }
                          if ((_formKey.currentState?.validate() ?? false)) {
                            ref
                                .read(addServiceMasterProvider.notifier)
                                .updateService(context,
                                    price: price.text,
                                    discount: discount.text,
                                    commissionFee: commission.text,
                                    pause: pause.text,
                                    interval: interval.text,
                                    serviceId: selectService?.id ?? 0,
                                    masterId: ref
                                            .watch(addServiceMasterProvider)
                                            .serviceData
                                            ?.master
                                            ?.id ??
                                        0, updated: () {
                                  Navigator.pop(context);
                              ref
                                  .read(serviceProvider.notifier)
                                  .fetchServices(
                                      context: context, isRefresh: true)
                                  .then((d) {
                                if (context.mounted) {
                                  Navigator.pop(context);
                                }
                              });
                            });
                          }
                        },
                      ),
                      60.verticalSpace,
                    ],
                  ),
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }
}
